<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error_helper->should_be_a_field_markup_generator($markup_generator);

$markup = array();
foreach($markup_generator->field_names as $field_name): 
	$markup[$field_name] = $markup_generator->field($field_name)->label_markup().$markup_generator->field($field_name)->field_markup(); //label has a sr-only class so that it will only be visible to screen readers
endforeach;

if($markup_generator->has_error){
	foreach($markup as $field_name => $field_markup){
		if(!$markup_generator->field($field_name)->validates() && $markup_generator->field($field_name)->has_error){
			$markup[$field_name] = '<div class="has-error">'.$field_markup.'</div>';
		}
	}
}

echo '<div class="form-inline"><div class="input-group">'.implode('<div class="input-group-addon">&ndash;</div>', $markup).'</div></div>';

?>


